<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Congratulations</title>
  <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
  <style>
    body {
      text-align: center;
      padding: 200px 0;
      position: relative; /* Needed for the ::before pseudo-element */
      margin: 0; /* Ensure no default margin */
    }

    body::before {
      content: ""; /* Required for pseudo-elements */
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgb(248, 255, 254); /* Background color */
      opacity: 0.8; /* Opacity */
      z-index: -1; /* Place behind content */
      background-image: url('/images/background.jpeg'); /* Background image */
      background-size: cover; /* Ensure the background image covers the whole body */
      background-repeat: no-repeat; /* Prevent background image from repeating */
      background-position: center; /* Center the background image */
    }

    h1 {
      color: #88B04B;
      font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
      font-weight: 900;
      font-size: 40px;
      margin-bottom: 10px;
    }

    p {
      color: #404F5E;
      font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
      font-size: 20px;
      margin: 0;
    }

    i {
      color: #04c5df;
      font-size: 100px;
      line-height: 200px;
      margin-left: -15px;
    }

    .card {
      background: white;
      padding: 60px;
      border-radius: 4px;
      box-shadow: 0 2px 3px #C8D0D8;
      display: inline-block;
      margin: 0 auto;
      position: relative; /* Ensure the card is positioned above the overlay */
      z-index: 1; /* Bring the card above the overlay */
    }
  </style>
</head>
<body>
  <div class="card">
    <div style="border-radius: 200px; height: 200px; width: 200px; background: #F8FAF5; margin: 0 auto;">
      <i class="checkmark">✓</i>
    </div>
    <h1>Congratulations!</h1>
    <p>Your form has been successfully submitted.<br/> We'll get in touch with you soon!</p>
  </div>
</body>
</html>
